; Compiled with: PIC Simulator IDE v7.37
; Microcontroller model: PIC16F688
; Clock frequency: 8.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R2L EQU 0x024
	R2H EQU 0x025
	R3L EQU 0x026
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R2HL EQU 0x024
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
	LONG_0 EQU 0x02A
	LONG_1 EQU 0x02B
	LONG_2 EQU 0x02C
	LONG_3 EQU 0x02D
	LONG2_0 EQU 0x02E
	LONG2_1 EQU 0x02F
	LONG2_2 EQU 0x030
	LONG2_3 EQU 0x031
	LONG1 EQU 0x02A
	LONG2 EQU 0x02E
;       The address of 'flashtime' (byte) (global) is 0x03D
;       The address of 'flashdelay' (byte) (global) is 0x03B
;       The address of 'servo_value' (word) (global) is 0x032
;       The address of 'min_servo' (word) (global) is 0x036
;       The address of 'old_min_servo' (word) (global) is 0x041
;       The address of 'max_servo' (word) (global) is 0x038
;       The address of 'old_max_servo' (word) (global) is 0x044
;       The address of 'direction' (byte) (global) is 0x03E
;       The address of 'old_hall_a' (bit) (global) is 0x03A,0
;       The address of 'old_hall_b' (bit) (global) is 0x03A,2
;       The address of 'old_hall_c' (bit) (global) is 0x03A,3
;       The address of 'old_hall_d' (bit) (global) is 0x03A,1
;       The address of 'count_enter' (byte) (global) is 0x027
;       The address of 'count_exit' (byte) (global) is 0x034
;       The address of 'program' (byte) (global) is 0x035
;       The address of 'end_reached' (bit) (global) is 0x03A,4
;       The address of 'advalue' (word) (global) is 0x03F
;       The address of 'time_before_barriers_down' (byte) (global) is 0x03C
;       The address of 'old_time_before_barriers_down' (byte) (global) is 0x043
;       The address of 'dummy' (byte) (global) is 0x046
;       The address of 'onoff' (bit) (flashes) is 0x03A,5
;       The address of 'pos_dir' (bit) (barrier_set) is 0x03A,6
;       The address of 'position' (word) (barrier_set) is 0x047
;       The address of 'hall_a' (bit) (global) is 0x005,5
;       The address of 'hall_b' (bit) (global) is 0x005,4
;       The address of 'hall_c' (bit) (global) is 0x005,3
;       The address of 'hall_d' (bit) (global) is 0x007,5
;       The address of 'servo_1' (bit) (global) is 0x007,3
;       The address of 'servo_2' (bit) (global) is 0x007,4
;       The address of 'pgm_mode' (bit) (global) is 0x007,2
;       The address of 'flash_1' (bit) (global) is 0x007,1
;       The address of 'flash_2' (bit) (global) is 0x007,0
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0009
	ORG 0x0004
	RETFIE
; User code start
L0009:
; 1: Define CONFIG = 0x3f50
; 2: 
; 3: 
; 4: 
; 5: 'program GCA186
; 6: 'railroad crossing controller for two directions
; 7: 
; 8: 'program option":
; 9: 'program = 0  idle task
; 10: '_         1  LEDS START FLASHING FOR 1.5 SECS AND SOUND IS SWItched on after time out program 2
; 11: '_         2  BARRIERS going down, wen down program 3
; 12: '_         3  waiting for counting down to zero, when zero program 4
; 13: '_         4  barriers going up, when up > program 5
; 14: '_         5  relay off, flashing off, waiting for last sensor to count tot zero, then program = 0
; 15: 
; 16: '-    Version 3 with PIC16F688 processor
; 17: '- this version uses potmeter for setting delay pre-barrier-down time amd servo limit positions.
; 18: '- Activating jumper will enable to adjust the current position of barriers
; 19: '- P1 (barriers up position)  and P3 (pre-barrier-down time) are only active when barriers are in reset mode
; 20: '- P2 is on;y active when barriers are in down position
; 21: '- jumper on, the barrier function are on hold, no magnets are sensed
; 22: '- do Not forget to take off jumper after adjusting !!!
; 23: 
; 24: 
; 25: TRISA = %11111111
	MOVLW 0xFF
	BSF STATUS,RP0
	MOVWF TRISA
	BCF STATUS,RP0
; 26: TRISC = %11100000
	MOVLW 0xE0
	BSF STATUS,RP0
	MOVWF TRISC
	BCF STATUS,RP0
; 27: PORTC = %00011000
	MOVLW 0x18
	MOVWF PORTC
; 28: PORTA = 255
	MOVLW 0xFF
	MOVWF PORTA
; 29: AllDigital
	BSF STATUS,RP0
	CLRF ANSEL
	MOVLW 0x07
	BCF STATUS,RP0
	MOVWF CMCON0
; 30: ANSEL = %00000111
	MOVLW 0x07
	BSF STATUS,RP0
	MOVWF ANSEL
	BCF STATUS,RP0
; 31: Symbol hall_a = RA5
; 32: Symbol hall_b = RA4
; 33: Symbol hall_c = RA3
; 34: Symbol hall_d = RC5
; 35: Symbol servo_1 = RC3
; 36: Symbol servo_2 = RC4
; 37: Symbol pgm_mode = RC2
; 38: Symbol flash_1 = RC1
; 39: Symbol flash_2 = RC0
; 40: 
; 41: Dim flashtime As Byte
	CLRF 0x03D
; 42: Dim flashdelay As Byte
	CLRF 0x03B
; 43: Dim servo_value As Word
	CLRF 0x032
	CLRF 0x033
; 44: Dim min_servo As Word
	CLRF 0x036
	CLRF 0x037
; 45: Dim old_min_servo As Word
	CLRF 0x041
	CLRF 0x042
; 46: Dim max_servo As Word
	CLRF 0x038
	CLRF 0x039
; 47: Dim old_max_servo As Word
	CLRF 0x044
	CLRF 0x045
; 48: Dim direction As Byte
	CLRF 0x03E
; 49: Dim old_hall_a As Bit
	BCF 0x03A,0
; 50: Dim old_hall_b As Bit
	BCF 0x03A,2
; 51: Dim old_hall_c As Bit
	BCF 0x03A,3
; 52: Dim old_hall_d As Bit
	BCF 0x03A,1
; 53: Dim count_enter As Byte
	CLRF 0x027
; 54: Dim count_exit As Byte
	CLRF 0x034
; 55: Dim program As Byte
	CLRF 0x035
; 56: Dim end_reached As Bit
	BCF 0x03A,4
; 57: Dim advalue As Word  'value from adconversion
	CLRF 0x03F
	CLRF 0x040
; 58: Dim time_before_barriers_down As Byte
	CLRF 0x03C
; 59: Dim old_time_before_barriers_down As Byte
	CLRF 0x043
; 60: Dim dummy As Byte
	CLRF 0x046
; 61: 
; 62: servo_1 = 1
	BSF PORTC,3
; 63: servo_2 = 1
	BSF PORTC,4
; 64: servo_value = max_servo  'start in barrier up position
	MOVF 0x038,W
	MOVWF 0x032
	MOVF 0x039,W
	MOVWF 0x033
; 65: program = 0
	CLRF 0x035
; 66: old_hall_a = 0
	BCF 0x03A,0
; 67: old_hall_b = 0
	BCF 0x03A,2
; 68: old_hall_c = 0
	BCF 0x03A,3
; 69: old_hall_d = 0
	BCF 0x03A,1
; 70: count_exit = 0
	CLRF 0x034
; 71: count_enter = 0
	CLRF 0x027
; 72: flash_1 = 1
	BSF PORTC,1
; 73: flash_2 = 1
	BSF PORTC,0
; 74: flashdelay = 0
	CLRF 0x03B
; 75: flashtime = 0
	CLRF 0x03D
; 76: Read 0, min_servo.LB
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x036
; 77: Read 1, min_servo.HB
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x037
; 78: If min_servo > 1600 Then
	MOVF 0x036,W
	MOVWF R0L
	MOVF 0x037,W
	MOVWF R0H
	MOVLW 0x40
	MOVWF R1L
	MOVLW 0x06
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0010
; 79: min_servo = 400
	MOVLW 0x90
	MOVWF 0x036
	MOVLW 0x01
	MOVWF 0x037
; 80: Endif
L0010:
; 81: old_min_servo = min_servo
	MOVF 0x036,W
	MOVWF 0x041
	MOVF 0x037,W
	MOVWF 0x042
; 82: Read 2, max_servo.LB
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x038
; 83: Read 3, max_servo.HB
	MOVLW 0x03
	BSF STATUS,RP0
	MOVWF EEADR
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x039
; 84: If max_servo > 1600 Then
	MOVF 0x038,W
	MOVWF R0L
	MOVF 0x039,W
	MOVWF R0H
	MOVLW 0x40
	MOVWF R1L
	MOVLW 0x06
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0011
; 85: max_servo = 1600
	MOVLW 0x40
	MOVWF 0x038
	MOVLW 0x06
	MOVWF 0x039
; 86: Endif
L0011:
; 87: old_max_servo = max_servo
	MOVF 0x038,W
	MOVWF 0x044
	MOVF 0x039,W
	MOVWF 0x045
; 88: Read 4, time_before_barriers_down
	MOVLW 0x04
	BSF STATUS,RP0
	MOVWF EEADR
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x03C
; 89: If time_before_barriers_down > 50 Then
	MOVF 0x03C,W
	SUBLW 0x32
	BTFSC STATUS,C
	GOTO L0012
; 90: time_before_barriers_down = 12
	MOVLW 0x0C
	MOVWF 0x03C
; 91: Endif
L0012:
; 92: old_time_before_barriers_down = time_before_barriers_down
	MOVF 0x03C,W
	MOVWF 0x043
; 93: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 94: main:
L0001:
; 95: For dummy = 1 To 15
	MOVLW 0x01
	MOVWF 0x046
L0013:
	MOVF 0x046,W
	SUBLW 0x0F
	BTFSS STATUS,C
	GOTO L0014
; 96: Gosub check_sensors
	CALL L0003
; 97: WaitMs 1
	MOVLW 0xC6
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
; 98: Next dummy
	MOVLW 0x01
	ADDWF 0x046,F
	BTFSS STATUS,C
	GOTO L0013
L0014:
; 99: Select Case program
; 100: Case 0  'idle task
	MOVF 0x035,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0015
; 101: count_enter = 0
	CLRF 0x027
; 102: count_exit = 0
	CLRF 0x034
; 103: end_reached = 1  'barriers are up
	BSF 0x03A,4
; 104: If pgm_mode = 0 Then
	BTFSC 0x007,2
	GOTO L0016
; 105: Gosub set_pos_barrier_up
	CALL L0006
; 106: Gosub set_wait_time
	CALL L0008
; 107: Endif
L0016:
; 108: Call flashes(0)
	BCF 0x03A,5
	CALL L0002
; 109: flashtime = 0
	CLRF 0x03D
; 110: flashdelay = 0
	CLRF 0x03B
; 111: direction = 0  'direction 1: first sensor =a  >>  direction =2 : first sensor = d
	CLRF 0x03E
; 112: Case 1  'activate flashing leds and soundrelay
	GOTO L0017
L0015:
	MOVF 0x035,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0018
; 113: Call flashes(1)
	BSF 0x03A,5
	CALL L0002
; 114: If flashtime > time_before_barriers_down Then  'enough flashing? start program 2
	MOVF 0x03D,W
	SUBWF 0x03C,W
	BTFSC STATUS,C
	GOTO L0019
; 115: program = 2
	MOVLW 0x02
	MOVWF 0x035
; 116: Endif
L0019:
; 117: 
; 118: Case 2  'barriers down
	GOTO L0020
L0018:
	MOVF 0x035,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0021
; 119: Call barrier_set(0, min_servo)
	BCF 0x03A,6
	MOVF 0x036,W
	MOVWF 0x047
	MOVF 0x037,W
	MOVWF 0x048
	CALL L0004
; 120: Call flashes(1)
	BSF 0x03A,5
	CALL L0002
; 121: If end_reached = 0 Then
	BTFSC 0x03A,4
	GOTO L0022
; 122: program = 3
	MOVLW 0x03
	MOVWF 0x035
; 123: Endif
L0022:
; 124: 
; 125: Case 3  'waiting for counting down count_enter
	GOTO L0023
L0021:
	MOVF 0x035,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0024
; 126: If pgm_mode = 0 Then
	BTFSC 0x007,2
	GOTO L0025
; 127: Gosub set_pos_barrier_down
	CALL L0007
; 128: Endif
L0025:
; 129: Call flashes(1)
	BSF 0x03A,5
	CALL L0002
; 130: If count_enter = 0 Then
	MOVF 0x027,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0026
; 131: program = 4
	MOVLW 0x04
	MOVWF 0x035
; 132: Endif
L0026:
; 133: Case 4  'barriers going up
	GOTO L0027
L0024:
	MOVF 0x035,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0028
; 134: Call barrier_set(1, max_servo)
	BSF 0x03A,6
	MOVF 0x038,W
	MOVWF 0x047
	MOVF 0x039,W
	MOVWF 0x048
	CALL L0004
; 135: Call flashes(1)
	BSF 0x03A,5
	CALL L0002
; 136: If end_reached = 1 Then
	BTFSS 0x03A,4
	GOTO L0029
; 137: program = 5
	MOVLW 0x05
	MOVWF 0x035
; 138: Endif
L0029:
; 139: Case 5  'waiting for count down count_exit
	GOTO L0030
L0028:
	MOVF 0x035,W
	SUBLW 0x05
	BTFSS STATUS,Z
	GOTO L0031
; 140: Call flashes(1)
	BSF 0x03A,5
	CALL L0002
; 141: If count_exit = 0 Then
	MOVF 0x034,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0032
; 142: program = 0
	CLRF 0x035
; 143: Call flashes(0)
	BCF 0x03A,5
	CALL L0002
; 144: WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	CALL W001
; 145: Endif
L0032:
; 146: Case Else
	GOTO L0033
L0031:
; 147: EndSelect
L0033:
L0030:
L0027:
L0023:
L0020:
L0017:
; 148: 
; 149: 
; 150: Goto main
	GOTO L0001
; 151: End
L0034:	GOTO L0034
; 152: Proc flashes(onoff As Bit)
L0002:
; 153: If onoff = 1 Then
	BTFSS 0x03A,5
	GOTO L0035
; 154: If flashdelay < 20 Then
	MOVLW 0x14
	SUBWF 0x03B,W
	BTFSC STATUS,C
	GOTO L0036
; 155: flashdelay = flashdelay + 1
	MOVF 0x03B,W
	ADDLW 0x01
	MOVWF 0x03B
; 156: Else
	GOTO L0037
L0036:
; 157: If flash_1 = 0 Then  'always keep 1 flash ON to keep relay activated.
	BTFSC 0x007,1
	GOTO L0038
; 158: flash_1 = 1
	BSF PORTC,1
; 159: flash_2 = 0
	BCF PORTC,0
; 160: Else
	GOTO L0039
L0038:
; 161: flash_2 = 1
	BSF PORTC,0
; 162: flash_1 = 0
	BCF PORTC,1
; 163: Endif
L0039:
; 164: flashdelay = 0
	CLRF 0x03B
; 165: flashtime = flashtime + 1
	MOVF 0x03D,W
	ADDLW 0x01
	MOVWF 0x03D
; 166: Endif
L0037:
; 167: Else
	GOTO L0040
L0035:
; 168: flash_1 = 0  'leds off
	BCF PORTC,1
; 169: flash_2 = 0
	BCF PORTC,0
; 170: flashtime = 0
	CLRF 0x03D
; 171: flashdelay = 0
	CLRF 0x03B
; 172: Endif
L0040:
; 173: End Proc
	RETURN
; 174: 
; 175: check_sensors:
L0003:
; 176: Select Case direction
; 177: Case 0  'program = also still 0!
	MOVF 0x03E,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0041
; 178: If hall_a = 0 Then
	BTFSC 0x005,5
	GOTO L0042
; 179: If old_hall_a = 0 Then
	BTFSC 0x03A,0
	GOTO L0043
; 180: program = 1
	MOVLW 0x01
	MOVWF 0x035
; 181: direction = 1
	MOVLW 0x01
	MOVWF 0x03E
; 182: count_enter = 1
	MOVLW 0x01
	MOVWF 0x027
; 183: count_exit = 1
	MOVLW 0x01
	MOVWF 0x034
; 184: old_hall_a = 1  'avoid the same been seen more than once in ome pass
	BSF 0x03A,0
; 185: Endif
L0043:
; 186: Else
	GOTO L0044
L0042:
; 187: old_hall_a = 0
	BCF 0x03A,0
; 188: Endif
L0044:
; 189: If hall_d = 0 Then
	BTFSC 0x007,5
	GOTO L0045
; 190: If old_hall_d = 0 Then
	BTFSC 0x03A,1
	GOTO L0046
; 191: program = 1
	MOVLW 0x01
	MOVWF 0x035
; 192: direction = 2  'approach from other side
	MOVLW 0x02
	MOVWF 0x03E
; 193: count_enter = 1
	MOVLW 0x01
	MOVWF 0x027
; 194: count_exit = 1
	MOVLW 0x01
	MOVWF 0x034
; 195: old_hall_d = 1  'avoid the same been seen more than once in ome pass
	BSF 0x03A,1
; 196: Endif
L0046:
; 197: Else
	GOTO L0047
L0045:
; 198: old_hall_d = 0
	BCF 0x03A,1
; 199: Endif
L0047:
; 200: 
; 201: Case 1  'forward from a to d
	GOTO L0048
L0041:
	MOVF 0x03E,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0049
; 202: If hall_a = 0 Then
	BTFSC 0x005,5
	GOTO L0050
; 203: If old_hall_a = 0 Then
	BTFSC 0x03A,0
	GOTO L0051
; 204: count_enter = count_enter + 1
	MOVF 0x027,W
	ADDLW 0x01
	MOVWF 0x027
; 205: count_exit = count_exit + 1
	MOVF 0x034,W
	ADDLW 0x01
	MOVWF 0x034
; 206: old_hall_a = 1  'avoid the same been seen more than once in ome pass
	BSF 0x03A,0
; 207: Endif
L0051:
; 208: Else
	GOTO L0052
L0050:
; 209: old_hall_a = 0
	BCF 0x03A,0
; 210: Endif
L0052:
; 211: If hall_c = 0 Then
	BTFSC 0x005,3
	GOTO L0053
; 212: If old_hall_c = 0 Then
	BTFSC 0x03A,3
	GOTO L0054
; 213: If count_enter > 0 Then
	MOVF 0x027,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0055
; 214: count_enter = count_enter - 1
	MOVLW 0x01
	SUBWF 0x027,W
	MOVWF 0x027
; 215: old_hall_c = 1  'avoid the same been seen more than once in ome pass
	BSF 0x03A,3
; 216: Endif
L0055:
; 217: Endif
L0054:
; 218: Else
	GOTO L0056
L0053:
; 219: old_hall_c = 0
	BCF 0x03A,3
; 220: Endif
L0056:
; 221: If hall_d = 0 Then
	BTFSC 0x007,5
	GOTO L0057
; 222: If old_hall_d = 0 Then
	BTFSC 0x03A,1
	GOTO L0058
; 223: If count_exit > 0 Then
	MOVF 0x034,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0059
; 224: count_exit = count_exit - 1
	MOVLW 0x01
	SUBWF 0x034,W
	MOVWF 0x034
; 225: old_hall_d = 1  'avoid the same been seen more than once in ome pass
	BSF 0x03A,1
; 226: Endif
L0059:
; 227: Endif
L0058:
; 228: Else
	GOTO L0060
L0057:
; 229: old_hall_d = 0
	BCF 0x03A,1
; 230: Endif
L0060:
; 231: Case Else  'reverse from d to a
	GOTO L0061
L0049:
; 232: If hall_d = 0 Then
	BTFSC 0x007,5
	GOTO L0062
; 233: If old_hall_d = 0 Then
	BTFSC 0x03A,1
	GOTO L0063
; 234: count_enter = count_enter + 1
	MOVF 0x027,W
	ADDLW 0x01
	MOVWF 0x027
; 235: count_exit = count_exit + 1
	MOVF 0x034,W
	ADDLW 0x01
	MOVWF 0x034
; 236: old_hall_d = 1  'avoid the same been seen more than once in ome pass
	BSF 0x03A,1
; 237: Endif
L0063:
; 238: Else
	GOTO L0064
L0062:
; 239: old_hall_d = 0
	BCF 0x03A,1
; 240: Endif
L0064:
; 241: If hall_b = 0 Then
	BTFSC 0x005,4
	GOTO L0065
; 242: If old_hall_b = 0 Then
	BTFSC 0x03A,2
	GOTO L0066
; 243: If count_enter > 0 Then
	MOVF 0x027,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0067
; 244: count_enter = count_enter - 1
	MOVLW 0x01
	SUBWF 0x027,W
	MOVWF 0x027
; 245: old_hall_b = 1
	BSF 0x03A,2
; 246: Endif
L0067:
; 247: Endif
L0066:
; 248: Else
	GOTO L0068
L0065:
; 249: old_hall_b = 0
	BCF 0x03A,2
; 250: Endif
L0068:
; 251: If hall_a = 0 Then
	BTFSC 0x005,5
	GOTO L0069
; 252: If old_hall_a = 0 Then
	BTFSC 0x03A,0
	GOTO L0070
; 253: If count_exit > 0 Then
	MOVF 0x034,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0071
; 254: count_exit = count_exit - 1
	MOVLW 0x01
	SUBWF 0x034,W
	MOVWF 0x034
; 255: old_hall_a = 1
	BSF 0x03A,0
; 256: Endif
L0071:
; 257: Endif
L0070:
; 258: Else
	GOTO L0072
L0069:
; 259: old_hall_a = 0
	BCF 0x03A,0
; 260: Endif
L0072:
; 261: EndSelect
L0061:
L0048:
; 262: 
; 263: Return
	RETURN
; 264: 
; 265: Proc barrier_set(pos_dir As Bit, position As Word)
L0004:
; 266: If pos_dir = 0 Then  'barriers go down
	BTFSC 0x03A,6
	GOTO L0073
; 267: If servo_value < position Then
	MOVF 0x032,W
	MOVWF R0L
	MOVF 0x033,W
	MOVWF R0H
	MOVF 0x047,W
	MOVWF R1L
	MOVF 0x048,W
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0074
; 268: servo_value = servo_value - 3
	MOVLW 0x03
	SUBWF 0x032,W
	MOVWF 0x032
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x033,W
	MOVWF 0x033
; 269: Call set_servo()
	CALL L0005
; 270: Else
	GOTO L0075
L0074:
; 271: end_reached = 1
	BSF 0x03A,4
; 272: servo_1 = 1
	BSF PORTC,3
; 273: servo_2 = 1
	BSF PORTC,4
; 274: Endif
L0075:
; 275: Else
	GOTO L0076
L0073:
; 276: If servo_value > position Then
	MOVF 0x032,W
	MOVWF R0L
	MOVF 0x033,W
	MOVWF R0H
	MOVF 0x047,W
	MOVWF R1L
	MOVF 0x048,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0077
; 277: servo_value = servo_value + 3
	MOVF 0x032,W
	ADDLW 0x03
	MOVWF 0x032
	MOVF 0x033,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x033
; 278: Call set_servo()
	CALL L0005
; 279: Else
	GOTO L0078
L0077:
; 280: end_reached = 1
	BSF 0x03A,4
; 281: servo_1 = 1
	BSF PORTC,3
; 282: servo_2 = 1
	BSF PORTC,4
; 283: Endif
L0078:
; 284: Endif
L0076:
; 285: End Proc
	RETURN
; 286: 
; 287: 
; 288: Proc set_servo()
L0005:
; 289: servo_1 = 1
	BSF PORTC,3
; 290: WaitUs servo_value
	MOVF 0x032,W
	MOVWF R4L
	MOVF 0x033,W
	MOVWF R4H
	CALL Y001
; 291: servo_1 = 0
	BCF PORTC,3
; 292: servo_2 = 1
	BSF PORTC,4
; 293: WaitUs servo_value
	MOVF 0x032,W
	MOVWF R4L
	MOVF 0x033,W
	MOVWF R4H
	CALL Y001
; 294: servo_2 = 0
	BCF PORTC,4
; 295: End Proc
	RETURN
; 296: 
; 297: set_pos_barrier_up:
L0006:
; 298: Adcin 0, advalue  'measure pot 1 for up position
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	MOVWF ADCON1
	BCF STATUS,RP0
	CLRF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x03F
	MOVF ADRESH,W
	MOVWF 0x040
; 299: max_servo = advalue + 400
	MOVF 0x03F,W
	ADDLW 0x90
	MOVWF 0x038
	MOVF 0x040,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x039
; 300: While servo_value < max_servo
L0079:
	MOVF 0x032,W
	MOVWF R0L
	MOVF 0x033,W
	MOVWF R0H
	MOVF 0x038,W
	MOVWF R1L
	MOVF 0x039,W
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0080
; 301: servo_value = servo_value + 1
	MOVF 0x032,W
	ADDLW 0x01
	MOVWF 0x032
	MOVF 0x033,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x033
; 302: servo_1 = 1
	BSF PORTC,3
; 303: servo_2 = 1
	BSF PORTC,4
; 304: WaitUs servo_value
	MOVF 0x032,W
	MOVWF R4L
	MOVF 0x033,W
	MOVWF R4H
	CALL Y001
; 305: servo_1 = 0
	BCF PORTC,3
; 306: servo_2 = 0
	BCF PORTC,4
; 307: WaitMs 15
	MOVLW 0xB6
	MOVWF R4L
	MOVLW 0x0B
	MOVWF R4H
	CALL DL02
; 308: Wend
	GOTO L0079
L0080:
; 309: While servo_value < max_servo
L0081:
	MOVF 0x032,W
	MOVWF R0L
	MOVF 0x033,W
	MOVWF R0H
	MOVF 0x038,W
	MOVWF R1L
	MOVF 0x039,W
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0082
; 310: servo_value = servo_value - 1
	MOVLW 0x01
	SUBWF 0x032,W
	MOVWF 0x032
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x033,W
	MOVWF 0x033
; 311: servo_1 = 1
	BSF PORTC,3
; 312: servo_2 = 1
	BSF PORTC,4
; 313: WaitUs servo_value
	MOVF 0x032,W
	MOVWF R4L
	MOVF 0x033,W
	MOVWF R4H
	CALL Y001
; 314: servo_1 = 0
	BCF PORTC,3
; 315: servo_2 = 0
	BCF PORTC,4
; 316: WaitMs 15
	MOVLW 0xB6
	MOVWF R4L
	MOVLW 0x0B
	MOVWF R4H
	CALL DL02
; 317: Wend
	GOTO L0081
L0082:
; 318: If old_max_servo <> max_servo Then
	MOVF 0x044,W
	MOVWF R0L
	MOVF 0x045,W
	MOVWF R0H
	MOVF 0x038,W
	MOVWF R1L
	MOVF 0x039,W
	MOVWF R1H
	CALL C002
	BTFSS STATUS,Z
	GOTO L0083
; 319: Write 2, max_servo.LB
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x038,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0084:	BTFSC EECON1,WR
	GOTO L0084
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 320: Write 3, max_servo.HB
	MOVLW 0x03
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x039,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0085:	BTFSC EECON1,WR
	GOTO L0085
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 321: old_max_servo = max_servo
	MOVF 0x038,W
	MOVWF 0x044
	MOVF 0x039,W
	MOVWF 0x045
; 322: Endif
L0083:
; 323: 
; 324: Return
	RETURN
; 325: 
; 326: set_pos_barrier_down:
L0007:
; 327: Adcin 1, advalue  'measure pot 2 for down position
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	MOVWF ADCON1
	MOVLW 0x01
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x03F
	MOVF ADRESH,W
	MOVWF 0x040
; 328: min_servo = advalue + 400
	MOVF 0x03F,W
	ADDLW 0x90
	MOVWF 0x036
	MOVF 0x040,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x037
; 329: If servo_value < min_servo Then
	MOVF 0x032,W
	MOVWF R0L
	MOVF 0x033,W
	MOVWF R0H
	MOVF 0x036,W
	MOVWF R1L
	MOVF 0x037,W
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0086
; 330: While servo_value < min_servo
L0087:
	MOVF 0x032,W
	MOVWF R0L
	MOVF 0x033,W
	MOVWF R0H
	MOVF 0x036,W
	MOVWF R1L
	MOVF 0x037,W
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0088
; 331: servo_value = servo_value + 1
	MOVF 0x032,W
	ADDLW 0x01
	MOVWF 0x032
	MOVF 0x033,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x033
; 332: servo_1 = 1
	BSF PORTC,3
; 333: servo_2 = 1
	BSF PORTC,4
; 334: WaitUs servo_value
	MOVF 0x032,W
	MOVWF R4L
	MOVF 0x033,W
	MOVWF R4H
	CALL Y001
; 335: servo_1 = 0
	BCF PORTC,3
; 336: servo_2 = 0
	BCF PORTC,4
; 337: WaitMs 15
	MOVLW 0xB6
	MOVWF R4L
	MOVLW 0x0B
	MOVWF R4H
	CALL DL02
; 338: Wend
	GOTO L0087
L0088:
; 339: old_min_servo = min_servo
	MOVF 0x036,W
	MOVWF 0x041
	MOVF 0x037,W
	MOVWF 0x042
; 340: Else
	GOTO L0089
L0086:
; 341: While servo_value > min_servo
L0090:
	MOVF 0x032,W
	MOVWF R0L
	MOVF 0x033,W
	MOVWF R0H
	MOVF 0x036,W
	MOVWF R1L
	MOVF 0x037,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0091
; 342: servo_value = servo_value - 1
	MOVLW 0x01
	SUBWF 0x032,W
	MOVWF 0x032
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x033,W
	MOVWF 0x033
; 343: servo_1 = 1
	BSF PORTC,3
; 344: servo_2 = 1
	BSF PORTC,4
; 345: WaitUs servo_value
	MOVF 0x032,W
	MOVWF R4L
	MOVF 0x033,W
	MOVWF R4H
	CALL Y001
; 346: servo_1 = 0
	BCF PORTC,3
; 347: servo_2 = 0
	BCF PORTC,4
; 348: WaitMs 15
	MOVLW 0xB6
	MOVWF R4L
	MOVLW 0x0B
	MOVWF R4H
	CALL DL02
; 349: Wend
	GOTO L0090
L0091:
; 350: Endif
L0089:
; 351: If old_min_servo <> min_servo Then
	MOVF 0x041,W
	MOVWF R0L
	MOVF 0x042,W
	MOVWF R0H
	MOVF 0x036,W
	MOVWF R1L
	MOVF 0x037,W
	MOVWF R1H
	CALL C002
	BTFSS STATUS,Z
	GOTO L0092
; 352: Write 0, min_servo.LB
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x036,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0093:	BTFSC EECON1,WR
	GOTO L0093
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 353: Write 1, min_servo.HB
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x037,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0094:	BTFSC EECON1,WR
	GOTO L0094
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 354: old_min_servo = min_servo
	MOVF 0x036,W
	MOVWF 0x041
	MOVF 0x037,W
	MOVWF 0x042
; 355: Endif
L0092:
; 356: Return
	RETURN
; 357: 
; 358: set_wait_time:
L0008:
; 359: Adcin 2, advalue  'read time_before_barriers_down
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	MOVWF ADCON1
	MOVLW 0x02
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x03F
	MOVF ADRESH,W
	MOVWF 0x040
; 360: advalue = advalue / 20
	MOVF 0x03F,W
	MOVWF R0L
	MOVF 0x040,W
	MOVWF R0H
	MOVLW 0x14
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x03F
	MOVF R0H,W
	MOVWF 0x040
; 361: time_before_barriers_down = advalue.LB
	MOVF 0x03F,W
	MOVWF 0x03C
; 362: If old_time_before_barriers_down <> time_before_barriers_down Then
	MOVF 0x043,W
	SUBWF 0x03C,W
	BTFSC STATUS,Z
	GOTO L0095
; 363: Write 4, time_before_barriers_down
	MOVLW 0x04
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x03C,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0096:	BTFSC EECON1,WR
	GOTO L0096
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 364: old_time_before_barriers_down = time_before_barriers_down
	MOVF 0x03C,W
	MOVWF 0x043
; 365: Endif
L0095:
; 366: Return
	RETURN
; End of user code
L0097:	GOTO L0097
;
;
; Delay Routine Byte
; minimal routine execution time: 4s
; routine execution time step: 1.5s
; maximal routine execution time: 385s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 7.5s
; routine execution time step: 5s
; maximal routine execution time: 327682.5s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0xC5
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
; Waitus Routine Word
; minimal routine execution time: 7.5s
; routine execution time step: 5s
Y001:	MOVLW 0x08
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
Y002:	MOVLW 0x05
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
;
;
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Adcin Routine
A001:	RLF R0L,F
	RLF R0L,F
	MOVLW 0x3C
	ANDWF R0L,F
	MOVLW 0xC0
	ANDWF ADCON0,F
	MOVF R0L,W
	IORWF ADCON0,F
	BSF ADCON0,ADON
	MOVLW 0x0B
	MOVWF R4L
	CALL DL01
	BSF ADCON0,GO
A002:
	BTFSC ADCON0,GO
	GOTO A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
